﻿----------------------------------------------------------------------------
----Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is always the best design." -------
---@v1.0.0.0----------------------------------------------------------------
----------------------------------------------------------------------------

engineSounds = {};
engineSounds.title = "Engine Sounds";
engineSounds.writeToLog = false;

function engineSounds:loadMap(savegame)
	print("Load mod: '"..engineSounds.title.."', by: ViperGTS96"); 
end;

Motorized.loadSounds = function(self, xmlFile, motorId)

	if self.isClient then

		local isMod = false;-----------------------------------Mod Start
		if string.find(self.baseDirectory, "pdlc") then
			isMod = true;
			if engineSounds.writeToLog then print("Mod"); end;
		elseif string.find(self.baseDirectory, "mods") then
			isMod = true;
			if engineSounds.writeToLog then print("Mod"); end;
		else
			if engineSounds.writeToLog then print("Vanilla"); end;
		end;---------------------------------------------------Mod Finish

		local spec = self.spec_motorized;
		local baseString = "vehicle.motorized.sounds";
		spec.samples = {};
		spec.samples.motorStart   = g_soundManager:loadSampleFromXML(xmlFile, baseString, "motorStart", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
		spec.samples.motorStop    = g_soundManager:loadSampleFromXML(xmlFile, baseString, "motorStop", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
		spec.samples.gearbox      = g_soundManager:loadSampleFromXML(xmlFile, baseString, "gearbox", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
		spec.samples.retarder     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "retarder", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
		if isMod then------------------------------------------Mod Start
			if motorId ~= nil and motorId > 1 then
				local configSampleStart = g_soundManager:loadSampleFromXML(xmlFile, baseString, "motorStart"..motorId, self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleStart ~= nil then spec.samples.motorStart = configSampleStart; end;
				local configSampleStop = g_soundManager:loadSampleFromXML(xmlFile, baseString, "motorStop"..motorId, self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleStop ~= nil then spec.samples.motorStop = configSampleStop; end;
				local configSampleGearbox = g_soundManager:loadSampleFromXML(xmlFile, baseString, "gearbox"..motorId, self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleGearbox ~= nil then spec.samples.gearbox = configSampleGearbox; end;
				local configSampleRetarder = g_soundManager:loadSampleFromXML(xmlFile, baseString, "retarder"..motorId, self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleRetarder ~= nil then spec.samples.retarder = configSampleRetarder; end;
			end;
		end;---------------------------------------------------Mod Finish
		spec.motorSamples = {};
		local i = 0;
		while true do
			local sample = g_soundManager:loadSampleFromXML(xmlFile, baseString, string.format("motor(%d)", i), self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
			if isMod then--------------------------------------Mod Start
				if motorId ~= nil and motorId > 1 then
					local configSample = g_soundManager:loadSampleFromXML(xmlFile, baseString, string.format("motor"..motorId.."(%d)", i), self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
					if configSample ~= nil then sample = configSample; end;
				end;
			end;-----------------------------------------------Mod Finish
			if sample == nil then
				break;
			end;
			table.insert(spec.motorSamples, sample);
			i = i + 1;
		end;
		spec.samples.airCompressorStart   = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorStart", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
		spec.samples.airCompressorStop    = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorStop", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
		spec.samples.airCompressorRun     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorRun", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
		spec.samples.compressedAir    = g_soundManager:loadSampleFromXML(xmlFile, baseString, "compressedAir", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
		if isMod then--------------------------------------Mod Start
			if motorId ~= nil and motorId > 1 then
				local configSampleCompressorStart = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorStart"..motorId, self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleCompressorStart ~= nil then spec.samples.airCompressorStart = configSampleCompressorStart; end;
				local configSampleCompressorStop = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorStop"..motorId, self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleCompressorStop ~= nil then spec.samples.airCompressorStop = configSampleCompressorStop; end;
				local configSampleCompressorRun  = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airCompressorRun"..motorId, self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleCompressorRun ~= nil then spec.samples.airCompressorRun = configSampleCompressorRun; end;
				local configSampleCompressedAir = g_soundManager:loadSampleFromXML(xmlFile, baseString, "compressedAir"..motorId, self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleCompressedAir ~= nil then spec.samples.compressedAir = configSampleCompressedAir; end;
			end;
		end;-----------------------------------------------Mod Finish
		if spec.samples.compressedAir ~= nil then
			spec.samples.compressedAir.brakeTime = 0;
			spec.samples.compressedAir.lastBrakeTime = 0;
		end;
		spec.samples.airRelease       = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airRelease", self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
		spec.samples.reverseDrive     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "reverseDrive", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
		spec.reverseDriveThreshold    = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.reverseDriveSound#threshold"), 4);
		spec.brakeCompressor = {};
		spec.brakeCompressor.capacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.brakeCompressor#capacity"), 6);
		spec.brakeCompressor.refillFilllevel = math.min(spec.brakeCompressor.capacity, Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.brakeCompressor#refillFillLevel"), spec.brakeCompressor.capacity/2));
		spec.brakeCompressor.fillSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorized.brakeCompressor#fillSpeed"), 0.6) / 1000;
		spec.brakeCompressor.fillLevel = 0;
		spec.brakeCompressor.doFill = true;
		spec.isBrakeSamplePlaying = false;
		spec.samples.brake     = g_soundManager:loadSampleFromXML(xmlFile, baseString, "brake", self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
		spec.compressionSoundTime = 0;
		
		if isMod then--------------------------------------Mod Start
			if motorId ~= nil and motorId > 1 then
				local configSampleAir = g_soundManager:loadSampleFromXML(xmlFile, baseString, "airRelease"..motorId, self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleAir ~= nil then spec.samples.airRelease = configSampleAir; end;
				local configSampleReverse = g_soundManager:loadSampleFromXML(xmlFile, baseString, "reverseDrive"..motorId, self.baseDirectory, self.components, 1, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleReverse ~= nil then spec.samples.reverseDrive = configSampleReverse; end;
				local configSampleBrake  = g_soundManager:loadSampleFromXML(xmlFile, baseString, "brake"..motorId, self.baseDirectory, self.components, 0, AudioGroup.VEHICLE, self.i3dMappings, self);
				if configSampleBrake ~= nil then spec.samples.brake = configSampleBrake; end;
			end;
		end;-----------------------------------------------Mod Finish

	end;
end;

addModEventListener(engineSounds);